import sys
from collections import Counter

input = sys.stdin.readline
n = int(input())

d1 = Counter()
d2 = Counter()
sx = Counter()
sy = Counter()

points = []

for _ in range(n):
    x, y = map(int, input().split())
    points.append((x, y))
    d1[x - y] += 1
    d2[x + y] += 1
    sx[(x, y % 2)] += 1
    sy[(y, x % 2)] += 1

def comb2(k):
    return k * (k - 1) // 2

ans = 0
for v in d1.values():
    ans += 2 * comb2(v)
for v in d2.values():
    ans += 2 * comb2(v)
for v in sx.values():
    ans += comb2(v)
for v in sy.values():
    ans += comb2(v)

print(ans)